﻿var serial_Check,ExpressionTimelineGlobals,aeFolder,userinterface,timelineFolder;

{
function getIcon(iconFile,encodedStr)
{
var retFile,binStr;
{
retFile = iconFile;
if(! retFile.exists)
{
binStr = base64Decode(encodedStr);
retFile = new File(retFile.fsName);
retFile.encoding = "BINARY";
if(retFile.open("w"))
{
retFile.write(binStr);
retFile.close();
}
else
{
myError((((loc({en:"Could not create the following file:",de:"Konnte folgende Datei nicht erzeugen:"}) + retFile.absoluteURI) + "\n") + loc({en:"Make sure that you have \"Allow Scripts to Write Files and Access Network\" enabled in your AE Preferences (Edit->Preferences->General).\n\nError Message:\n",de:"Achte darauf, dass Du die Option \"Skripten k\xf6nnen Dateien schreiben und haben Netzwerkzugang\" unter Bearbeiten->Voreinstellungen->Allgemein aktiviert hast.\n\nFehlermeldung:\n"})) + retFile.error);
}
}
return  retFile;
}
}
function base64Decode(input)
{
var output,i,chr1,chr2,chr3,enc1,enc2,enc3,enc4,key;
{
output = "";
i = 0;
input = input.replace(RegExp("[^A-Za-z0-9\\+\\/\\=]","g"),"");
key = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
while (i < input.length)
{
enc1 = key.indexOf(input.charAt(i++));
enc2 = key.indexOf(input.charAt(i++));
enc3 = key.indexOf(input.charAt(i++));
enc4 = key.indexOf(input.charAt(i++));
chr1 = (enc1 << 2) | (enc2 >> 4);
chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
chr3 = ((enc3 & 3) << 6) | enc4;
output = output + String.fromCharCode(chr1);
if(enc3 != 64)
{
output = output + String.fromCharCode(chr2);
}
if(enc4 != 64)
{
output = output + String.fromCharCode(chr3);
}
}
return  output;
}
}
function allowedToWriteFiles(reportError)
{
var result,securitySetting;
{
securitySetting = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY");
result = securitySetting == 1;
if(! result && reportError)
{
myError(loc({en:("Some files for " + ExpressionTimelineGlobals.scriptName) + " cannot be created.\nPlease enable \"Allow Scripts to Write Files and Access Network\" in your AE Preferences (Edit->Preferences->General).",de:("Einige Dateien f\xfcr " + ExpressionTimelineGlobals.scriptName) + " k\xf6nnen nicht erzeugt werden.\nBitte aktiviere die Option \"Skripten k\xf6nnen Dateien schreiben und haben Netzwerkzugang\" unter Bearbeiten->Voreinstellungen->Allgemein."}));
}
return  result;
}
}
function addslashes(str)
{
{
return  str + "".replace(RegExp("([\\\\\"'])","g"),"\\$1").replace(RegExp("\\u0000","g"),"\\0");
}
}
function encode(string)
{
var encoded;
{
encoded = addslashes(string);
encoded = encoded.replace(RegExp("[\\r\\n]+","g"),"\\n");
return  encoded;
}
}
function getLines(text)
{
var temp,lines;
{
temp = text.replace(RegExp("(\\r\\n)|(\\r)|(\\n)","g"),"\n");
lines = temp.split("\n");
if(lines[lines.length - 1] == "")
{
lines.length--;
}
return  lines;
}
}
function generateExpression(timeSliceVector,propValType)
{
var i,myLinebreak,j,endTime,sBefore,sAfter,funct1,funct2,result,lines,s;
{
result = "";
myLinebreak = ExpressionTimelineGlobals.isMacOS?"\r":"\n";
result += "// SERIALIZATION OF TIMELINE START\n";
for (  i=0 ; i<timeSliceVector.length ; i = i+1)
{
s = timeSliceVector[i];
lines = getLines(s.serialize());
for (  j=0 ; j<lines.length ; j = j+1)
{
result += (("//" + lines[j]) + myLinebreak);
}
}
result += "// SERIALIZATION OF TIMELINE END\n\n\n";
for (  i=0 ; i<timeSliceVector.length ; i = i+1)
{
s = timeSliceVector[i];
if(s.type == "expression")
{
result += (((((("function exp" + i) + "(){\n") + "return eval('") + encode(timeSliceVector[i].expressionText)) + "');\n") + "};");
}
}
result += "function useKeyframes(){return eval('value');};";
for (  i=0 ; i<timeSliceVector.length ; i = i+1)
{
s = timeSliceVector[i];
endTime = (s.endTime == "infinity")?"thisComp.duration":(s.endTime + "*thisComp.frameDuration");
result += (("if(time <= " + endTime) + "){");
if(s.type == "expression")
{
result += (("exp" + i) + "()");
}
else
if(s.type == "keyframes")
{
result += "useKeyframes()";
}
else
if(s.type == "fadeOver")
{
if(i == 0)
{
myError(loc({en:"Error in function generateExpression:\nfadeOver may not be the first region!",de:"Fehler in der Funktion generateExpression:\nfadeOver darf nicht die erste Region sein!"}));
return  false;
}
if(i == timeSliceVector.length)
{
myError(loc({en:"Error in function generateExpression:\nfadeOver may not be the last region!",de:"Fehler in der Funktion generateExpression:\nfadeOver darf nicht die letzte Region sein!"}));
return  false;
}
sBefore = timeSliceVector[i - 1];
sAfter = timeSliceVector[i + 1];
if((sBefore.type != "expression") && (sBefore.type != "keyframes"))
{
myError(loc({en:"Error in function generateExpression:\nRegion before fadeOver must be of type expression or keyframes!",de:"Fehler in der Funktion generateExpression:\nRegion vor fadeOver muss vom Typ expression oder Keyframes sein"}));
return  false;
}
if((sAfter.type != "expression") && (sAfter.type != "keyframes"))
{
myError(loc({en:"Error in function generateExpression:\nregion after fadeOver must be of type expression or keyframes!",de:"Fehler in der Funktion generateExpressions:\nRegion nach dem fadeOver muss vom Typ Expression oder Keyframes sein!"}));
return  false;
}
funct1 = (sBefore.type == "expression")?("exp" + (i - 1)):"useKeyframes";
funct2 = (sAfter.type == "expression")?("exp" + (i + 1)):"useKeyframes";
if(propValType == PropertyValueType.TEXT_DOCUMENT)
{
result += (((((((((((((("var stringA=" + funct1) + "();") + "var stringB=") + funct2) + "(); ") + "var part = ((time/thisComp.frameDuration)-") + s.startTime) + ")/(") + s.endTime) + "-") + s.startTime) + ");") + "var splitpoint=part*Math.max(stringA.length,stringB.length);") + "stringB.substring(0,splitpoint)+stringA.substring(splitpoint,stringA.length)");
}
else
{
result += ((((((((" linear(time, tMin=" + s.startTime) + "*thisComp.frameDuration, tMax=") + s.endTime) + "*thisComp.frameDuration, ") + funct1) + "(), ") + funct2) + "())");
}
}
result += "}";
result += "else ";
}
result += "{ value}\n";
return  result;
}
}
function generateGeneralTimeSlice(startTime,endTime)
{
var slice;
{
slice = new Object();
slice.startTime = startTime;
slice.endTime = endTime;
slice.type = "undef-Type";
slice.serializeHeader = function ()
{
{
return  ((((("SLICE TYPE " + this.type) + " START ") + this.startTime) + " END ") + this.endTime) + "\n";
}
}
;
return  slice;
}
}
function generateTimeSliceExpression(startTime,endTime,expressionText)
{
var slice;
{
expressionText.replace(RegExp("(\\r\\n)|(\\r)|(\\n)","g"),"\n");
slice = generateGeneralTimeSlice(startTime,endTime);
slice.type = "expression";
slice.expressionText = expressionText;
slice.serialize = function ()
{
var result,lines;
{
lines = getLines(this.expressionText);
result = "";
result += this.serializeHeader();
result += (("EXPRESSION NUMLINES " + lines.length) + "\n");
result += this.expressionText;
return  result;
}
}
;
return  slice;
}
}
function generateTimeSliceKeyframes(startTime,endTime)
{
var slice;
{
slice = generateGeneralTimeSlice(startTime,endTime);
slice.type = "keyframes";
slice.serialize = function ()
{
{
return  this.serializeHeader();
}
}
;
return  slice;
}
}
function generateTimeSliceFadeOver(startTime,endTime)
{
var slice;
{
slice = generateGeneralTimeSlice(startTime,endTime);
slice.type = "fadeOver";
slice.serialize = function ()
{
{
return  this.serializeHeader();
}
}
;
return  slice;
}
}
function loadTimeSlicesFromExpression(serialization)
{
var i,endTime,parse,result,lines,startTime,expStart,expEnd,expSlice,sliceType,expExpression,parseExp,len,srcText;
{
result = new Array();
lines = getLines(serialization);
i = 0;
expStart = RegExp("^\\s*\\/\\/\\s*SERIALIZATION\\s*OF\\s*TIMELINE\\s*START\\s*$","");
expEnd = RegExp("^\\s*\\/\\/\\s*SERIALIZATION\\s*OF\\s*TIMELINE\\s*END\\s*$","");
while ((i < lines.length) && ! expStart.test(lines[i]))
{
i++;
}
if(i == lines.length)
{
result.push(generateTimeSliceExpression(0,"infinity",serialization));
}
else
{
i++;
expSlice = RegExp("^\\s*\\/\\/\\s*SLICE\\s+TYPE\\s+(\\S+)\\s+START\\s+(\\S+)\\s+END\\s+(\\S+)\\s*$","");
while ((i < lines.length) && ! expEnd.test(lines[i]))
{
if(! expSlice.test(lines[i]))
{
myError(loc({en:(("Cannot reconstruct timeline due to unexprected line " + i) + " in expression:\n") + lines[i],de:(("Kann die Timeline nicht rekonstruieren, da die Expression die folgende unerwartete Zeile (Zeile " + i) + ") enth\xe4lt:\n") + lines[i]}));
result = new Array();
result.push(generateTimeSliceKeyframes(0,"infinity"));
return  result;
}
parse = expSlice.exec(lines[i]);
sliceType = parse[1];
startTime = parseFloat(parse[2]);
endTime = (parse[3] == "infinity")?"infinity":parseFloat(parse[3]);
if(sliceType == "expression")
{
i++;
if(i >= lines.length)
{
myError(loc({en:(("Cannot reconstruct the timeline due to unexprected end of expression after line " + (i - 1)) + ":\n") + lines[i - 1],de:(("Kann die Timeline nicht rekonstruieren, da die Expression unerwartet nach Zeile " + (i - 1)) + " endet:\n") + lines[i - 1]}));
result = new Array();
result.push(generateTimeSliceKeyframes(0,"infinity"));
return  result;
}
expExpression = RegExp("^\\s*\\/\\/\\s*EXPRESSION\\s+NUMLINES\\s*(\\S+)\\s*$","");
if(! expExpression.test(lines[i]))
{
myError(loc({en:(((("Cannot reconstruct timeline due to unexprected line " + i) + " in expression:\n") + lines[i]) + "\n") + "Expected something like \"// EXPRESSION NUMLINES 2\"",de:(((("Kann die Timeline wegen einer unerwarteten Zeile in der Expression (Zeile " + i) + ") nicht rekonstruieren:\n") + lines[i]) + "\n") + "Erwartet wird etwas wie \"// EXPRESSION NUMLINES 2\""}));
result = new Array();
result.push(generateTimeSliceKeyframes(0,"infinity"));
return  result;
}
parseExp = expExpression.exec(lines[i]);
len = parseExp[1];
i++;
srcText = "";
while (len > 0)
{
srcText += (lines[i].slice(2,lines[i].length) + "\n");
len--;
i++;
}
i--;
result.push(generateTimeSliceExpression(startTime,endTime,srcText));
}
else
if(sliceType == "keyframes")
{
result.push(generateTimeSliceKeyframes(startTime,endTime));
}
else
if(sliceType == "fadeOver")
{
result.push(generateTimeSliceFadeOver(startTime,endTime));
}
else
{
myError(loc({en:(((("Cannot reconstruct timeline due to unknown sliceType \"" + sliceType) + "\" in line ") + i) + ":\n") + lines[i],de:(((("Kann die Timeline nicht rekonstruieren wegen unbekanntem sliceType \"" + sliceType) + "\" in Zeile ") + i) + ":\n") + lines[i]}));
result = new Array();
result.push(generateTimeSliceKeyframes(0,"infinity"));
return  result;
}
i++;
}
}
return  result;
}
}
function makeTimesTight(timeSliceVector)
{
var i;
{
for (  i=1 ; i<timeSliceVector.length ; i = i+1)
{
timeSliceVector[i - 1].endTime = timeSliceVector[i].startTime - 1;
}
timeSliceVector[0].startTime = 0;
timeSliceVector[timeSliceVector.length - 1].endTime = "infinity";
}
}
function addStartAndEndSlice(timeSliceVector)
{
var endTime,startTime;
{
startTime = timeSliceVector[0].startTime;
endTime = timeSliceVector[timeSliceVector.length - 1].endTime;
if(startTime > 0)
{
timeSliceVector.splice(0,0,generateTimeSliceKeyframes(0,startTime - 1));
}
if(endTime != "infinity")
{
timeSliceVector.push(generateTimeSliceKeyframes(endTime + 1,"infinity"));
}
}
}
function addTimelineUIEntry(UI)
{
var expressionUIstring,keyframesUIstring,frameMarkerUIstring,fadeUIstring,entryUIstring,entry;
{
expressionUIstring = ((((("Panel{\n\t\torientation:'column',margins:0,spacing:2,alignment:['fill','fill'],alignChildren:['center','top'],\n\t\ttypeLabel:StaticText{text:'Expression'},\n\t\texpression:EditText{properties:{multiline:true,scrollable:true},text:'',preferredSize:[150,80],alignment:['fill','fill'],helpTip:'" + loc({en:"expression that should be active at this time.",de:"Expression, die in dieser Zeit aktiv ist."})) + "'},\n\t\tdeleteBtn:Button{text:'") + loc({en:"Delete",de:"L\xf6schen"})) + "',alignment:['center','bottom'],helpTip:'") + loc({en:"deletes this entry from the timeline",de:"L\xf6scht diesen Eintrag aus der Timeline"})) + "'}\n\t\t}";
keyframesUIstring = ((((((("Panel{\n\t\torientation:'column',margins:0,spacing:2,alignment:['fill','fill'],alignChildren:['center','top'],\n\t\ttypeLabel:StaticText{text:'Keyframes'},\n\t\tinsertExpressionBtn:Button{text:'" + loc({en:"Add Expression",de:"Neue Expression"})) + "',alignment:['center','center'],helpTip:'") + loc({en:"insert a new expression",de:"neue Expression einf\xfcgen"})) + "'},\n\t\tdeleteBtn:Button{text:'") + loc({en:"Delete",de:"L\xf6schen"})) + "',alignment:['center','bottom'],helpTip:'") + loc({en:"deletes this entry from the timeline",de:"L\xf6scht diesen Eintrag aus der Timeline"})) + "'}\n\t\t}";
frameMarkerUIstring = ((((((((("Group{\n\t\torientation:'column',margins:2,alignment:['fill','fill'],\n\t\tframeLabel:StaticText{text:'Frame'},\n\t\tframeTime:EditText{text:'0',characters:6,helpTip:'" + loc({en:"Start-/Endpoint of the timeline entries",de:"Start- bzw. End-Zeitpunkt der Timeline-Eintr\xe4ge"})) + "'},\n\t\taddFadeBtn:Button{text:'") + loc({en:"Add Fade",de:"\xdcberblendung"})) + "',alignment:['center','center'],helpTip:'") + loc({en:"Add a smooth transition between the expression/keyframes left and right.",de:"Erzeugt einen weichen \xdcbergang zwischen der Expression bzw. den Keyframes links und rechts."})) + "'},\n\t\tinsertBoxBtn:Button{text:'") + loc({en:"Insert Box",de:"Box einf\xfcgen"})) + "',alignment:['center','center'],helpTip:'") + loc({en:"Adds a new time window (for a new expression or keyframes).",de:"Erzeugt ein neues Zeitfenster (f\xfcr Expressions oder Keyframes)."})) + "'}\n\t\t}";
fadeUIstring = ((((((((((((("Group{\n\t\torientation:'column',margins:0,spacing:2,alignment:['fill','fill'],alignChildren:['center','top'],\n\t\tmidTimeLabel:StaticText{text:'Frame',helpTip:'" + loc({en:"mid-point of the fade",de:"Mittelpunkt der \xdcberblendung"})) + "'},\n\t\tmidTime:EditText{text:'0',characters:6,helpTip:'") + loc({en:"mid-point of the fade",de:"Mittelpunkt der \xdcberblendung"})) + "'},\n\t\tdurationLabel1:StaticText{text:'") + loc({en:"Fade of",de:"\xdcberblendung"})) + "'},\n\t\tdurationLabel2:StaticText{text:'") + loc({en:"Duration",de:"der Dauer"})) + "'},\n\t\tduration:EditText{text:'0',characters:6,helpTip:'") + loc({en:"duration of the fade (in frames)",de:"Dauer der \xdcberblendung (in Frames)"})) + "'},\n\t\tdeleteBtn:Button{text:'") + loc({en:"Delete",de:"L\xf6schen"})) + "',alignment:['center','bottom'],helpTip:'") + loc({en:"deletes this entry from the timeline",de:"L\xf6scht diesen Eintrag aus der Timeline"})) + "'}\n\t\t}";
entryUIstring = ((((((("group{\n\t\torientation:'row',spacing:0,\n\t\tmarker:Group{\n\t\t\torientation:'stack',\n\t\t\tframeMarker:" + frameMarkerUIstring) + ",\n\t\t\tfade:") + fadeUIstring) + "\n\t\t\t},\n\t\tentry:Group{\n\t\t\torientation:'stack',\n\t\t\tkeyframes:") + keyframesUIstring) + ",\n\t\t\texpression:") + expressionUIstring) + "\n\t\t\t}\n\t\t}";
entry = UI.add(entryUIstring);
entry.marker.frameMarker.frameTime.onChange = function ()
{
var timeSliceVector,myIndex,newFromTime,minValue,maxValue;
{
myIndex = this.parent.parent.parent.entry.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
if(this.text == "infinity")
{
if(myIndex != timeSliceVector.length)
{
myError(loc({en:"No entry is allowed to start at frame infinity.",de:"Kein Eintrag darf beim Frame infinity (unendlich) anfangen."}));
this.text = timeSliceVector[myIndex].startTime;
}
return  ;
}
newFromTime = parseInt(this.text,10);
if(isNaN(newFromTime))
{
this.text = (myIndex >= timeSliceVector.length)?"infinity":timeSliceVector[myIndex].startTime;
return  ;
}
minValue = (myIndex == 0)?0:(timeSliceVector[myIndex - 1].startTime + 1);
maxValue = (myIndex >= (timeSliceVector.length - 1))?0x3B9AC9FF:timeSliceVector[myIndex].endTime;
if(newFromTime < minValue)
{
myError(loc({en:(((("The value must be inbetween " + minValue) + " and ") + maxValue) + " because otherwise neighbouring entries (or fades) are overwritten.\n") + " Use the delete button, if you really want to replace the neighbouring entries.",de:(((("Der Wert muss zwischen " + minValue) + " und ") + maxValue) + " liegen, da sonst benachbarte Eintr\xe4ge (oder \xdcberblendungen) \xfcberschrieben werden.\n") + " Benutze den L\xf6schen-Button, wenn Du wirklich die benachbarten Eintr\xe4ge ersetzen willst."}));
this.text = (myIndex >= timeSliceVector.length)?"infinity":timeSliceVector[myIndex].startTime;
return  ;
}
if((maxValue != "infinity") && (newFromTime > maxValue))
{
myError(loc({en:(((("The value must be inbetween " + minValue) + " and ") + maxValue) + " because otherwise neighbouring entries (or fades) are overwritten.\n") + " Use the delete button, if you really want to replace the neighbouring entries.",de:(((("Der Wert muss zwischen " + minValue) + " und ") + maxValue) + " liegen, da sonst benachbarte Eintr\xe4ge (oder \xdcberblendungen) \xfcberschrieben werden.\n") + " Benutze den L\xf6schen-Button, wenn Du wirklich die benachbarten Eintr\xe4ge ersetzen willst."}));
this.text = (myIndex >= timeSliceVector.length)?"infinity":timeSliceVector[myIndex].startTime;
return  ;
}
if(myIndex > 0)
{
timeSliceVector[myIndex - 1].endTime = newFromTime - 1;
}
if(myIndex <= (timeSliceVector.length - 1))
{
timeSliceVector[myIndex].startTime = newFromTime;
}
addStartAndEndSlice(timeSliceVector);
updateTimelineUI();
updateTimelineUI();
}
}
;
entry.marker.frameMarker.addFadeBtn.onClick = function ()
{
var timeSliceVector,endTime,myIndex,startTime,fadeDuration,halfDuration;
{
myIndex = this.parent.parent.parent.entry.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
fadeDuration = ExpressionTimelineGlobals.defaultFadeDuration;
halfDuration = parseInt(fadeDuration / 2);
halfDuration = Math.min(halfDuration,timeSliceVector[myIndex - 1].endTime - timeSliceVector[myIndex - 1].startTime);
if(timeSliceVector[myIndex].endTime != "infinity")
{
halfDuration = Math.min(halfDuration,timeSliceVector[myIndex].endTime - timeSliceVector[myIndex].startTime);
}
startTime = (timeSliceVector[myIndex].startTime - halfDuration) + 1;
endTime = (startTime + fadeDuration) - 1;
startTime = Math.max(startTime,timeSliceVector[myIndex - 1].startTime + 1);
if(timeSliceVector[myIndex].endTime != "infinity")
{
endTime = Math.min(endTime,timeSliceVector[myIndex].endTime - 1);
}
timeSliceVector[myIndex - 1].endTime = startTime - 1;
timeSliceVector[myIndex].startTime = endTime + 1;
timeSliceVector.splice(myIndex,0,generateTimeSliceFadeOver(startTime,endTime));
updateTimelineUI();
}
}
;
entry.marker.frameMarker.insertBoxBtn.onClick = function ()
{
var timeSliceVector,endTime,myIndex,startTime;
{
myIndex = this.parent.parent.parent.entry.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
startTime = timeSliceVector[myIndex].startTime;
endTime = startTime;
timeSliceVector[myIndex - 1].endTime = startTime - 1;
timeSliceVector[myIndex].startTime = endTime + 1;
timeSliceVector.splice(myIndex,0,generateTimeSliceKeyframes(startTime,endTime));
updateTimelineUI();
}
}
;
entry.entry.expression.deleteBtn.onClick = entry.entry.keyframes.deleteBtn.onClick = function ()
{
var timeSliceVector,myIndex,numberOfElements,startIndex;
{
myIndex = this.parent.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
numberOfElements = 1;
startIndex = myIndex;
if((myIndex > 0) && (timeSliceVector[myIndex - 1].type == "fadeOver"))
{
numberOfElements++;
startIndex--;
}
if(((myIndex + 1) < timeSliceVector.length) && (timeSliceVector[myIndex + 1].type == "fadeOver"))
{
numberOfElements++;
}
timeSliceVector.splice(startIndex,numberOfElements);
makeTimesTight(timeSliceVector);
updateTimelineUI();
}
}
;
entry.marker.fade.deleteBtn.onClick = function ()
{
var timeSliceVector,myIndex,numberOfElements,startIndex,midTime;
{
myIndex = this.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
numberOfElements = 1;
startIndex = myIndex;
midTime = parseInt((timeSliceVector[myIndex].endTime + timeSliceVector[myIndex].startTime) / 2);
timeSliceVector[myIndex - 1].endTime = midTime - 1;
timeSliceVector[myIndex + 1].startTime = midTime;
timeSliceVector.splice(startIndex,numberOfElements);
makeTimesTight(timeSliceVector);
updateTimelineUI();
}
}
;
entry.entry.expression.expression.onChange = function ()
{
var timeSliceVector,expressionText,myIndex,clipboard,emptyLineExpression;
{
myIndex = this.parent.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
expressionText = this.text;
if(ExpressionTimelineGlobals.isMacOS)
{
clipboard = system.callSystem("pbpaste");
if(clipboard.replace(RegExp("\\r","g"),"") == expressionText)
{
expressionText = clipboard;
}
}
emptyLineExpression = RegExp("^\\s*$","");
if(emptyLineExpression.test(expressionText))
{
timeSliceVector[myIndex] = generateTimeSliceKeyframes(timeSliceVector[myIndex].startTime,timeSliceVector[myIndex].endTime);
updateTimelineUI();
}
else
{
timeSliceVector[myIndex].expressionText = expressionText;
}
}
}
;
entry.entry.keyframes.insertExpressionBtn.onClick = function ()
{
var timeSliceVector,myIndex;
{
myIndex = this.parent.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
timeSliceVector[myIndex] = generateTimeSliceExpression(timeSliceVector[myIndex].startTime,timeSliceVector[myIndex].endTime,"value");
updateTimelineUI();
}
}
;
entry.marker.fade.duration.onChange = function ()
{
var duration,newEndTime,newStartTime,minStart,maxEnd,timeSliceVector,maxStartToMid,maxEndToMid,maxDuration,slice,myIndex,halfDuration,midTime;
{
myIndex = this.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
slice = timeSliceVector[myIndex];
duration = parseInt(this.text);
if(isNaN(duration))
{
this.text = (slice.endTime - slice.startTime) + 1;
return  ;
}
midTime = parseInt((slice.startTime + slice.endTime) / 2);
halfDuration = parseInt(duration / 2);
newEndTime = midTime + halfDuration;
newStartTime = (newEndTime - duration) + 1;
minStart = timeSliceVector[myIndex - 1].startTime + 1;
maxEnd = ((myIndex + 1) == (timeSliceVector.length - 1))?"infinity":(timeSliceVector[myIndex + 1].endTime - 1);
maxStartToMid = midTime - minStart;
maxEndToMid = (maxEnd == "infinity")?"infinity":(maxEnd - midTime);
maxDuration = Math.min((maxStartToMid * 2) + 1,(maxEndToMid == "infinity")?((maxStartToMid * 2) + 1):(maxEndToMid * 2));
if(duration < 1)
{
myError(loc({en:"Fade duration must be greater than 0.",de:"Dauer der \xdcberblendung muss gr\xf6\xdfer als 0 sein."}));
updateTimelineUI();
return  ;
}
else
if(duration > maxDuration)
{
myError(loc({en:(("Fade duration must be at most " + maxDuration) + " since otherwise no frames are left for the element before/after the fade.\n") + "You can move the elements before or after the fade to increase this range.",de:(("Die Dauer der \xdcberblendung darf h\xf6chstens " + maxDuration) + " sein, da sonst keine Frames f\xfcr die Elemente vor oder nach der \xdcberblendung \xfcbrig sind.\n") + "Du kannst die Elemente davor oder danach verschieben um mehr Platz f\xfcr die \xdcberblendung zu schaffen."}));
updateTimelineUI();
return  ;
}
slice.startTime = newStartTime;
slice.endTime = newEndTime;
timeSliceVector[myIndex - 1].endTime = newStartTime - 1;
timeSliceVector[myIndex + 1].startTime = newEndTime + 1;
updateTimelineUI();
}
}
;
entry.marker.fade.midTime.onChange = function ()
{
var newEndTime,newStartTime,minStart,maxEnd,timeSliceVector,slice,oldMidTime,newMidTime,midToStart,midToEnd,myIndex,minMid,maxMid;
{
myIndex = this.parent.sliceIndex;
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
slice = timeSliceVector[myIndex];
oldMidTime = parseInt((slice.startTime + slice.endTime) / 2);
newMidTime = parseInt(this.text);
if(isNaN(newMidTime))
{
this.text = oldMidTime;
return  ;
}
midToStart = oldMidTime - slice.startTime;
midToEnd = slice.endTime - oldMidTime;
newStartTime = newMidTime - midToStart;
newEndTime = newMidTime + midToEnd;
minStart = timeSliceVector[myIndex - 1].startTime + 1;
maxEnd = ((myIndex + 1) == (timeSliceVector.length - 1))?"infinity":(timeSliceVector[myIndex + 1].endTime - 1);
minMid = minStart + midToStart;
maxMid = (maxEnd == "infinity")?"infinity":(maxEnd - midToEnd);
if(newMidTime == "infinity")
{
myError(loc({en:"A fade may not be located at frame infinity.",de:"Eine \xdcberblendung darf nicht bei Frame infinity (unendlich) sein"}));
updateTimelineUI();
return  ;
}
else
if((newMidTime < minMid) || ((maxMid != "infinity") && (newMidTime > maxMid)))
{
myError(loc({en:((((("The mid-point of the fade may only be inbetween frame " + minMid) + " and ") + maxMid) + " since otherwise no frames are left for the element before/after the fade.\n") + "You can shorten the fade duration or move the element ") + "before or after the fade to increase this range.",de:(((((("Der Mittelpunkt der \xdcberblendung darf nur zwischen Frame " + minMid) + " und Frame ") + maxMid) + " liegen,") + " da sonst keine Frames f\xfcr die Elemente links oder rechts von der \xdcberblendung \xfcbrig sind.\n") + "Du kannst die \xdcberblendung verk\xfcrzen oder die Elemente vor/nach der \xdcberblendung verschieben, ") + "um die \xdcberblendung noch weiter verschieben zu k\xf6nnen."}));
updateTimelineUI();
return  ;
}
slice.startTime = newStartTime;
slice.endTime = newEndTime;
timeSliceVector[myIndex - 1].endTime = newStartTime - 1;
timeSliceVector[myIndex + 1].startTime = newEndTime + 1;
updateTimelineUI();
return  ;
}
}
;
}
}
function getNumBoxes(timeSliceVector)
{
var i,count;
{
count = 1;
for (  i=0 ; i<timeSliceVector.length ; i = i+1)
{
if((timeSliceVector[i].type == "expression") || (timeSliceVector[i].type == "keyframes"))
{
count++;
}
}
return  count;
}
}
function updateTimelineUI()
{
var UI,i,timeSliceVector,slice,numBoxes,nextSliceIndex,entry;
{
timeSliceVector = ExpressionTimelineGlobals.timeSlices;
UI = ExpressionTimelineGlobals.timelineUI;
numBoxes = getNumBoxes(timeSliceVector);
while (numBoxes > UI.children.length)
{
addTimelineUIEntry(UI);
}
nextSliceIndex = 0;
for (  i=0 ; i<UI.children.length ; i = i+1)
{
entry = UI.children[i];
if(nextSliceIndex > timeSliceVector.length)
{
entry.visible = false;
}
else
if(nextSliceIndex == timeSliceVector.length)
{
entry.visible = true;
entry.marker.visible = true;
entry.marker.frameMarker.visible = true;
entry.marker.frameMarker.frameTime.text = "infinity";
entry.marker.fade.visible = false;
entry.marker.frameMarker.addFadeBtn.visible = false;
entry.marker.frameMarker.insertBoxBtn.visible = false;
entry.entry.visible = false;
entry.entry.sliceIndex = nextSliceIndex;
nextSliceIndex++;
}
else
{
slice = timeSliceVector[nextSliceIndex];
if(slice.type == "fadeOver")
{
entry.marker.frameMarker.visible = false;
entry.marker.fade.visible = true;
entry.marker.fade.midTime.text = parseInt((slice.startTime + slice.endTime) / 2);
entry.marker.fade.duration.text = (slice.endTime - slice.startTime) + 1;
entry.marker.fade.sliceIndex = nextSliceIndex;
nextSliceIndex++;
slice = timeSliceVector[nextSliceIndex];
}
else
{
entry.marker.frameMarker.visible = true;
entry.marker.fade.visible = false;
entry.marker.frameMarker.frameTime.text = slice.startTime;
if(nextSliceIndex == 0)
{
entry.marker.frameMarker.addFadeBtn.visible = false;
entry.marker.frameMarker.insertBoxBtn.visible = false;
}
else
{
entry.marker.frameMarker.addFadeBtn.visible = true;
entry.marker.frameMarker.insertBoxBtn.visible = true;
if(((timeSliceVector[nextSliceIndex].endTime != "infinity") && ((timeSliceVector[nextSliceIndex].endTime - timeSliceVector[nextSliceIndex].startTime) < 3)) || ((timeSliceVector[nextSliceIndex - 1].endTime - timeSliceVector[nextSliceIndex - 1].startTime) < 3))
{
entry.marker.frameMarker.addFadeBtn.enabled = false;
entry.marker.frameMarker.insertBoxBtn.enabled = false;
}
else
{
entry.marker.frameMarker.addFadeBtn.enabled = true;
entry.marker.frameMarker.insertBoxBtn.enabled = true;
}
}
}
if(slice.type == "expression")
{
entry.entry.expression.visible = true;
entry.entry.keyframes.visible = false;
entry.entry.expression.expression.text = slice.expressionText;
entry.entry.expression.deleteBtn.enabled = ! ((nextSliceIndex == 0) && (timeSliceVector.length == 1));
entry.entry.sliceIndex = nextSliceIndex;
}
else
if(slice.type == "keyframes")
{
entry.entry.keyframes.visible = true;
entry.entry.expression.visible = false;
entry.entry.keyframes.deleteBtn.enabled = ! ((nextSliceIndex == 0) && (timeSliceVector.length == 1));
entry.entry.sliceIndex = nextSliceIndex;
}
else
{
myError("unexpected slice type!");
}
entry.visible = true;
entry.marker.visible = true;
entry.entry.visible = true;
nextSliceIndex++;
}
}
ExpressionTimelineGlobals.pal.layout.layout(true);
ExpressionTimelineGlobals.pal.layout.resize();
ExpressionTimelineGlobals.pal.layout.layout(true);
}
}
function buildUI(thisObj)
{
var pal,userInterface;
{
pal = (thisObj instanceof Panel)?thisObj:new Window("palette",(ExpressionTimelineGlobals.scriptName + " ") + ExpressionTimelineGlobals.scriptVersion,undefined,{resizeable:true});
if(pal == null)
return  pal;
userInterface = ((((((((((((((((((("group{\n\t\t\t\torientation:'column', \n\t\t\t\talignment:['left','top'],\n\t\t\t\talignChildren:['fill','fill'],\n\t\t\t\tmargins:0,\n\t\t\t\t logoBtn: " + (ExpressionTimelineGlobals.logoFile.exists?(("IconButton { icon:'" + ExpressionTimelineGlobals.logoFile.absoluteURI) + "',alignment:['left','top']}, "):(("Button {text: '" + loc({en:"Click here for Help (logo file missing)",de:"Hilfe (Logo Datei fehlt)"})) + "'}, "))) + "\n\t\t\t\tcontrols:Group{\n\t\t\t\t\t\torientation:'row', \n\t\t\t\t\t\talignment:['fill','fill'],\n\t\t\t\t\t\talignChildren:['left','center'],\n\t\t\t\t\t\tmargins:0,\n\t\t\t\t\t\tapplyBtn:Button{text:'") + loc({en:"Apply",de:"Anwenden"})) + "',helpTip:'") + loc({en:"apply the expression timeline to the selected property/properties.",de:"Wendet die gesamte Timeline auf die ausgew\xe4hlte(n) Eigenschaft(en) an."})) + "'},\n\t\t\t\t\t\tloadBtn:Button{text:'") + loc({en:"Load",de:"Laden"})) + "',helpTip:'") + loc({en:"loads the expression or expression timeline fom the selected property.",de:"L\xe4d die Expression oder Expression Timeline von der aktuell ausgew\xe4hlten Eigenschaft."})) + "'},\n\t\t\t\t\t\tclearBtn: Button { text:'") + loc({en:"Clear All",de:"Alles L\xf6schen"})) + "',helpTip:'") + loc({en:"reset expression timeline",de:"Expression Timeline zur\xfccksetzen"})) + "' },\n\t\t\t\t\t\ttimelineWidthLabel:StaticText{text:'") + loc({en:"max. timeline width:",de:"max. Timeline-Breite:"})) + "',alignment:['right','center'],helpTip:'") + loc({en:"max. width of the timeline window in the user interface",de:"maximale Breite des Timeline-Fensters in der Benutzeroberfl\xe4che."})) + "'},\n\t\t\t\t\t\ttimelineWidthText:EditText{text:'500',characters:6,alignment:['right','center'],helpTip:'") + loc({en:"max. width of the timeline window in the user interface",de:"maximale Breite des Timeline-Fensters in der Benutzeroberfl\xe4che."})) + "'},\n\t\t\t\t\t\thelpBtn:Button{text:'?',preferredSize:[20,20],alignment:['right','center']}\n\t\t\t\t\t},\n\t\t\t\ttimeline:Group{alignment:['left','fill'],\n\t\t\t\t\torientation:'column',spacing:7,margins:2,\n\t\t\t\t\tentries:Group{spacing:1,alignment:['left','fill']},\n\t\t\t\t\tscroll:Scrollbar{alignment:['fill','bottom']}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t";
pal.margins = 4;
pal.UI = pal.add(userInterface);
ExpressionTimelineGlobals.pal = pal;
ExpressionTimelineGlobals.timelineUI = pal.UI.timeline.entries;
pal.UI.timeline.scroll.minimumSize = [30,0];
pal.UI.timeline.scroll.maximumSize = [1000,20];
pal.UI.timeline.scroll.minValue = 0;
pal.UI.timeline.scroll.maxValue = 100;
updateTimelineUI();
pal.UI.timeline.entries.layout = new ScrollableLayout(pal.UI.timeline.entries,pal.UI.timeline.scroll,pal.UI.controls.timelineWidthText);
pal.layout.layout(true);
pal.layout.resize();
pal.onResizing = pal.onResize = function ()
{
{
this.layout.resize();
this.layout.layout(true);
}
}
;
pal.UI.controls.timelineWidthText.onChange = function ()
{
var newWidth;
{
newWidth = parseInt(this.text);
if(isNaN(newWidth) || (newWidth < 300))
{
myError("The width of the Timeline Interface must be at least 300.");
this.text = 500;
}
pal.layout.layout(true);
}
}
;
pal.UI.logoBtn.onClick = pal.UI.controls.helpBtn.onClick = function ()
{
var helpWindow,helpDlg;
{
helpWindow = new Window("dialog",ExpressionTimelineGlobals.scriptName + " Help",undefined,{resizeable:true});
helpDlg = ((((((((((((((((("group{\n\t\t\torientation:'column', \n\t\t\tpreferredSize:[600,300],\n\t\t\talignment:['fill','fill'],\n\t\t\tmargins:0,\n\t\t\tlicenseText: StaticText{text:'" + getLicenseInfo()) + "'},\n\t\t\tlanguage:Group{\n\t\t\t\torientation:'row', \n\t\t\t\talignment:['left','top'],\n\t\t\t\tlanguageText: StaticText{text:'") + loc({en:"User Interface Language",de:"Interface Sprache"})) + "'},\n\t\t\t\tlangAuto: RadioButton{text:'auto', value:") + (ExpressionTimelineGlobals.language == "auto")) + ", helpTip:'") + loc({en:"choose language automatically",de:"Sprache automatisch bestimmen"})) + "'},\n\t\t\t\tlangEn: RadioButton{text:'en', value:") + (ExpressionTimelineGlobals.language == "en")) + ", helpTip:'English user interface'},\n\t\t\t\tlangDe: RadioButton{text:'de', value:") + (ExpressionTimelineGlobals.language == "de")) + ", helpTip:'deutsche Benutzeroberfl\xe4che'}\n\t\t\t\t},\n\t\t\tupdate:Group{ alignment:['left','top']\n\t\t\t\tonlineUpdateCheckBox:Checkbox{text:'") + loc({en:"Check for online updates every 10 days",de:"Pr\xfcfe alle 10 Tage auf Online-Updates"})) + "', value:") + (ExpressionTimelineGlobals.onlineUpdate?"true":"false")) + ",alignment:['left','center']},\n\t\t\t\tcheckNow:Button{text:'") + loc({en:"Check now for updates",de:"Pr\xfcfe jetzt auf Updates"})) + "',alignment:['left','center']}\n\t\t\t\t},\n\t\t\thelpbox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\n\t\t\tokBtn:Button{text:'OK',alignment:['center','bottom']}\n\t\t\t}";
helpWindow.UI = helpWindow.add(helpDlg);
helpWindow.UI.language.langAuto.onClick = function ()
{
{
ExpressionTimelineGlobals.language = "auto";
app.settings.saveSetting(ExpressionTimelineGlobals.settingsSection,"language",ExpressionTimelineGlobals.language);
alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",de:"Die \xc4nderungen der Sprache werden erst wirksam, nachdem das Skript neu gestartet worden ist. Dazu gen\xfcgt es, das Hauptfenster des Skriptes zu schlie\xdfen und wieder neu zu \xf6ffnen"}),"Info");
}
}
;
helpWindow.UI.language.langEn.onClick = function ()
{
{
ExpressionTimelineGlobals.language = "en";
app.settings.saveSetting(ExpressionTimelineGlobals.settingsSection,"language",ExpressionTimelineGlobals.language);
alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",de:"Die \xc4nderungen der Sprache werden erst wirksam, nachdem das Skript neu gestartet worden ist. Dazu gen\xfcgt es, das Hauptfenster des Skriptes zu schlie\xdfen und wieder neu zu \xf6ffnen"}),"Info");
}
}
;
helpWindow.UI.language.langDe.onClick = function ()
{
{
ExpressionTimelineGlobals.language = "de";
app.settings.saveSetting(ExpressionTimelineGlobals.settingsSection,"language",ExpressionTimelineGlobals.language);
alert(loc({en:"The language change will take effect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",de:"Die \xc4nderungen der Sprache werden erst wirksam, nachdem das Skript neu gestartet worden ist. Dazu gen\xfcgt es, das Hauptfenster des Skriptes zu schlie\xdfen und wieder neu zu \xf6ffnen"}),"Info");
}
}
;
helpWindow.UI.okBtn.onClick = function ()
{
{
helpWindow.close();
}
}
;
helpWindow.UI.update.onlineUpdateCheckBox.onClick = function ()
{
var storeVal;
{
ExpressionTimelineGlobals.onlineUpdate = this.value;
storeVal = ExpressionTimelineGlobals.onlineUpdate?"true":"false";
app.settings.saveSetting(ExpressionTimelineGlobals.settingsSection,"onlineUpdate",storeVal);
}
}
;
helpWindow.UI.update.checkNow.onClick = function ()
{
{
checkUpdates(false);
}
}
;
helpWindow.UI.helpbox.text = ExpressionTimelineGlobals.helpText;
helpWindow.onResizing = pal.onResize = function ()
{
{
this.layout.resize();
}
}
;
helpWindow.show();
}
}
;
pal.UI.controls.loadBtn.onClick = function ()
{
var index,property,comp;
{
comp = app.project.activeItem;
if((comp == null) || ! (comp instanceof CompItem))
{
myError(loc({en:"Please select a composition.",de:"Bitte w\xe4hle eine Komposition aus."}));
return  false;
}
if(comp.selectedProperties.length < 1)
{
myError(loc({en:"Please select exactly one property from which the expression should be loaded.",de:"Bitte w\xe4hle genau eine Eigenschaft aus, von der die Expression geladen werden soll."}));
return  false;
}
index = 0;
while ((index < comp.selectedProperties.length) && (comp.selectedProperties[index] instanceof PropertyGroup))
{
index++;
}
if(index >= comp.selectedProperties.length)
{
myError(loc({en:"Please select exactly one property from which the expression should be loaded.",de:"Bitte w\xe4hle genau eine Eigenschaft aus, von der die Expression geladen werden soll."}));
return  false;
}
property = comp.selectedProperties[index];
if(! property.canSetExpression || (property.expression == ""))
{
myError(loc({en:"The selected property does not contain any expression that could be loaded.",de:"Die ausgew\xe4hlte Eigenschaft enth\xe4lt keine Expression, die geladen werden k\xf6nnte."}));
return  false;
}
ExpressionTimelineGlobals.timeSlices = loadTimeSlicesFromExpression(property.expression);
updateTimelineUI();
}
}
;
pal.UI.controls.applyBtn.onClick = function ()
{
var i,expressionText,comp,count,properties;
{
comp = app.project.activeItem;
if((comp == null) || ! (comp instanceof CompItem))
{
myError(loc({en:"Please select a composition.",de:"Bitte w\xe4hle eine Komposition aus."}));
return  false;
}
properties = comp.selectedProperties;
if(properties.length < 1)
{
myError(loc({en:"Please select at least one property to which the expressions in the timeline should be applied.",de:"Bitte w\xe4hle mindestens eine Eigenschaft aus, auf die die Expressions in der Timeline angewendet werden sollen."}));
return  false;
}
app.beginUndoGroup("apply " + ExpressionTimelineGlobals.scriptName);
count = 0;
for (  i=0 ; i<properties.length ; i = i+1)
{
if(properties[i].canSetExpression)
{
expressionText = generateExpression(ExpressionTimelineGlobals.timeSlices,properties[i].propertyValueType);
properties[i].expression = expressionText;
statusMessage(loc({en:"generated expression for ",de:"generiere Expression f\xfcr "}) + properties[i].name);
count++;
}
}
app.endUndoGroup();
if(count == 0)
{
myError(loc({en:"None of the selected properties accepts expressions. Please select a property to which the expressions in the timeline can be applied.",de:"Keine der ausgew\xe4hlten Eigenschaften akzeptiert Expressions. Bitte w\xe4hle eine Eigenschaft, auf die die Expressions in der Timeline angewendet werden k\xf6nnen."}));
return  false;
}
statusMessage(loc({en:("generated " + count) + " expression(s).",de:count + " Expression(s) generiert"}));
}
}
;
pal.UI.controls.clearBtn.onClick = function ()
{
{
ExpressionTimelineGlobals.timeSlices.length = 0;
ExpressionTimelineGlobals.timeSlices.push(generateTimeSliceKeyframes(0,"infinity"));
updateTimelineUI();
}
}
;
pal.UI.timeline.scroll.onChanging = pal.UI.timeline.scroll.onChange = function ()
{
{
pal.UI.layout.layout(true);
}
}
;
return  pal;
}
}
function myError(message)
{
{
alert(message,ExpressionTimelineGlobals.scriptName + ": Error");
}
}
function statusMessage(message)
{
{
writeLn((ExpressionTimelineGlobals.scriptName + ":") + message);
}
}
function loc(obj)
{
var localString;
{
if(ExpressionTimelineGlobals.language != "auto")
{
$.locale = ExpressionTimelineGlobals.language;
localString = localize(obj);
$.locale = null;
return  localString;
}
else
{
return  localize(obj);
}
}
}
function ScrollableLayout(container,scroll,windowWidth)
{
{
this.initSelf(container,scroll,windowWidth);
}
}
function SL_initSelf(container,scroll,windowWidth)
{
{
this.container = container;
this.scroll = scroll;
this.windowWidth = windowWidth;
}
}
function SL_layout()
{
var totalHeight,totalWidth,numEntries,scrollRange,child,width,availableWidth;
{
width = 0;
availableWidth = parseInt(this.windowWidth.text);
totalHeight = 0;
totalWidth = 0;
numEntries = this.container.children.length;
for (  i=0 ; i<numEntries ; i = i+1)
{
child = this.container.children[i];
if(typeof child.layout != "undefined")
{
child.layout.layout();
}
totalHeight = Math.max(totalHeight,child.preferredSize.height);
if(child.visible)
{
totalWidth += (child.entry.visible?child.preferredSize.width:child.marker.preferredSize.width);
}
}
if(i < this.container.children.length)
{
totalWidth += this.container.children[i].marker.preferredSize.width;
}
this.container.preferredSize = [totalWidth,totalHeight];
scrollRange = Math.max(0,totalWidth - availableWidth);
width = 0 - parseInt((this.scroll.value / 100) * scrollRange,10);
for (  i=0 ; i<this.container.children.length ; i = i+1)
{
child = this.container.children[i];
child.size = [child.preferredSize[0],totalHeight];
child.preferredSize = child.size;
child.layout.layout();
child.location = [width,0];
width += child.size.width;
}
this.scroll.enabled = availableWidth < totalWidth;
width = Math.min(availableWidth,totalWidth);
this.scroll.preferredSize[0] = width;
this.scroll.size = this.scroll.preferredSize;
this.container.preferredSize = [width,totalHeight];
}
}
function GetVersion(scriptname)
{
var fileName,url,port,file,domain,conn,contentLengthHeader,contentLength,headerLength,reply,recievedVersion,call;
{
url = "notify.aescripts.com/versioncheck.php?id=" + scriptname;
port = 80;
domain = (url.split("/")[0] + ":") + port;
fileName = url.substr(url.lastIndexOf("/") + 1);
call = "GET ";
if(url.indexOf("/") < 0)
{
call += "/";
}
else
{
call += url.substr(url.indexOf("/"));
}
call += " HTTP/1.1\n";
call += (("Host: " + domain) + "\n\n");
call += "Connection: close\n\n";
reply = new String();
file = new File();
file.encoding = "binary";
file.open("w");
conn = new Socket();
conn.encoding = "binary";
if(conn.open(domain,"binary"))
{
conn.write(call);
reply = conn.read(300);
contentLengthHeader = String(reply.match(RegExp("Content-Length: [0-9]*","")));
contentLength = contentLengthHeader.substr(16);
headerLength = reply.indexOf("\n\n") + 2;
reply += conn.read((contentLength + headerLength) - 300);
recievedVersion = reply.toString().substring(reply.toString().lastIndexOf("BeginVersion") + 12,reply.toString().lastIndexOf("EndVersion"));
conn.close();
}
else
{
reply = "";
}
return  recievedVersion;
}
}
function checkUpdates(silent)
{
{
checkUpdatesGeneric(silent,ExpressionTimelineGlobals);
}
}
function checkUpdatesGeneric(silent,myGlobals)
{
var checkTime,timeCheck,lastCheck,mostRecent;
{
if(silent)
{
checkTime = new Date();
timeCheck = parseFloat(checkTime.getTime() / 1000);
lastCheck = 0;
if(app.settings.haveSetting(myGlobals.settingsSection,"lastUpdateCheck"))
{
lastCheck = parseFloat(app.settings.getSetting(myGlobals.settingsSection,"lastUpdateCheck").toString());
}
if(((timeCheck - lastCheck) / 0x15180) > 10)
{
app.settings.saveSetting(myGlobals.settingsSection,"lastUpdateCheck",timeCheck);
}
else
{
return  ;
}
}
try 
{
mostRecent = parseFloat(GetVersion(myGlobals.scriptURLName));
}

catch (e)
{
if(! silent)
{
myError(loc({en:"There was an error connecting to the update server, please try again. Make sure that you have \"Allow Scripts to Write Files and Access Network\" enabled in your AE Preferences (Edit->Preferences->General).",de:"Konnte keine Verbindung zum Update-Server herstellen. Achte darauf, dass Du die Option \"Skripten k\xf6nnen Dateien schreiben und haben Netzwerkzugang\" unter Bearbeiten->Voreinstellungen->Allgemein aktiviert hast."}));
}
return  ;
}
if(! isNaN(mostRecent))
{
if(mostRecent > parseFloat(myGlobals.scriptVersionNumber.toString()))
{
alert(loc({en:((((("A new version of " + myGlobals.scriptName) + " is available.\nYou can download it at http://www.mamoworld.com") + "\nyour version: ") + myGlobals.scriptVersionNumber.toString()) + "\nnew version: ") + mostRecent,de:((((("Eine neue Version von " + myGlobals.scriptName) + " ist verf\xfcgbar.\nDu kannst sie auf http://www.mamoworld.com herunterladen.") + "\nDeine Version: ") + myGlobals.scriptVersionNumber.toString()) + "\nNeue Version: ") + mostRecent}));
}
else
{
if(! silent)
{
alert(loc({en:("Your version (" + myGlobals.scriptVersionNumber.toString()) + ") is up to date. There are no updates available.",de:("Deine Version (" + myGlobals.scriptVersionNumber.toString()) + ") ist aktuell. Es sind keine Updates verf\xfcgbar."}));
}
}
}
else
{
if(! silent)
{
myError(loc({en:"There was an error connecting to the update server, please try again.",de:"Konnte keine Verbindung zum Update-Server herstellen."}));
}
}
}
}
function getLicenseInfo()
{
	myLicense = " -  Site license";
	result = "Registered to: " + "CG Persia" + " " + myLicense;	
	return  result;
var multiLicense,result,strScriptName,prefsSectionName,prefsName,myReg,myRegArray,regFirstName,regLastName,numLicenses,matchMutliLic,regName,regLicense,myLicense;
{
result = "";
strScriptName = "ExpressionTimeline";
prefsSectionName = "aescripts";
prefsName = strScriptName + "_Registration";
myReg = app.settings.haveSetting(prefsSectionName,prefsName)?app.settings.getSetting(prefsSectionName,prefsName):"";
myRegArray = myReg.split("**");
if(myRegArray.length == 3)
{
regFirstName = myRegArray[0];
regLastName = myRegArray[1];
numLicenses = 1;
matchMutliLic = regLastName.match(RegExp("([^\\(]+)\\(([0-9]+)_Users\\)$",""));
if((matchMutliLic != null) && (matchMutliLic.length == 3))
{
regLastName = matchMutliLic[1];
numLicenses = parseFloat(matchMutliLic[2]);
}
regName = (regFirstName + " ") + regLastName;
regLicense = myRegArray[2].substring(myRegArray[2].length - 3,myRegArray[2].length);
multiLicense = (numLicenses > 1)?loc({en:" Users",de:" Benutzer"}):loc({en:" User",de:" Benutzer"});
if(regLicense == "SUL")
myLicense = (loc({en:" -  License for ",de:" -  Lizenz f\xfcr "}) + numLicenses) + multiLicense;
if(regLicense == "STE")
myLicense = " -  Site license";
result = ((loc({en:"Registered to: ",de:"Registriert f\xfcr "}) + regName) + " ") + myLicense;
}
else
{
if(ExpressionTimelineGlobals.demoLeft)
{
result = ExpressionTimelineGlobals.demoLeft;
}
else
{
result = "invalid license";
}
}
return  result;
}
}

function checkEula(myGlobals)
{
var eulaAccepted,eulaWindow,eulaDlg;
{
eulaAccepted = app.settings.haveSetting(myGlobals.settingsSection,"eulaAccepted")?app.settings.getSetting(myGlobals.settingsSection,"eulaAccepted"):false;
if(eulaAccepted)
{
return  true;
}
eulaWindow = new Window("dialog",myGlobals.scriptName + loc({en:" License Agreement",de:" Lizenzbestimmungen"}),undefined,{resizeable:true});
eulaDlg = ((("group{\n\t\t\torientation:'column', \n\t\t\talignment:['fill','fill'],\n\t\t\tpreferredSize:[400,200],\n\t\t\tmargins:0,\n\t\t\teulabox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\n\t\t\tagree:Checkbox{text:'" + loc({en:"I accept the licence agreement.",de:"Ich akzeptiere die Lizenzbestimmungen."})) + "', value:false,alignment:['left','bottom']},\n\t\t\tbuttonsGrp:Group{ alignment:['center','bottom']\n\t\t\t\tokBtn:Button{text:'OK',alignment:['center','bottom'],enabled:false},\n\t\t\t\tcancelBtn:Button{text:'") + loc({en:"Cancel",de:"Abbrechen"})) + "',alignment:['center','bottom']}\n\t\t\t\t}\n\t\t\t}";
eulaWindow.UI = eulaWindow.add(eulaDlg);
eulaWindow.UI.agree.onClick = function ()
{
{
eulaWindow.UI.buttonsGrp.okBtn.enabled = eulaWindow.UI.agree.value;
}
}
;
eulaWindow.UI.buttonsGrp.okBtn.onClick = function ()
{
{
eulaAccepted = eulaWindow.UI.agree.value;
eulaWindow.close();
}
}
;
eulaWindow.UI.buttonsGrp.cancelBtn.onClick = function ()
{
{
eulaWindow.close();
}
}
;
eulaWindow.UI.eulabox.text = myGlobals.eula;
eulaWindow.onResizing = eulaWindow.onResize = function ()
{
{
this.layout.resize();
}
}
;
eulaWindow.show();
if(eulaAccepted)
{
app.settings.saveSetting(myGlobals.settingsSection,"eulaAccepted",true);
}
return  eulaAccepted;
}
}
function expressiontimeline_trial_serialization()
{
var supportEmail,trialLengthDays,trialLengthLaunches,strTrialUrl,strExpiredAlert,strRegSuccess,strInvalidCode,strCorruptedCode,strTrialThanks,strTrialTxt,strTrialTxt2,strTrialWelcomeHeader,strErrScriptAccess,winProgramFiles,winBrowserCmd,macBrowserCmdStart,macBrowserCmdEnd,cmdKey,strTrialWelcomeMsg,privateNum,prefHeader,prefSection1,prefSection2,doPrompt,regOK,strScriptName,prefsSectionName,myLicence,prefsName,theLicense,myReg;
{
function checkTrial()
{
var trialExpired,today,one_day,todayInMsFixed,trialStartDate,launchCount,trialLengthSoFar,trialDaysLeft,launchesLeft;
{
trialExpired = false;
today = new Date();
one_day = 0x5265C00;
todayInMsFixed = (parseInt(today,10) / one_day) / 0xF4240.toFixed(6);
if(app.settings.haveSetting(prefHeader,prefSection1))
{
trialStartDate = app.settings.getSetting(prefHeader,prefSection1);
}
else
{
trialStartDate = todayInMsFixed;
app.settings.saveSetting(prefHeader,prefSection1,trialStartDate);
}
if(app.settings.haveSetting(prefHeader,prefSection2))
{
launchCount = parseInt(app.settings.getSetting(prefHeader,prefSection2),16) / 1000000000000;
app.settings.saveSetting(prefHeader,prefSection2,(launchCount + 1) * 1000000000000);
}
else
{
launchCount = 1;
app.settings.saveSetting(prefHeader,prefSection2,launchCount * 1000000000000);
}
app.preferences.saveToDisk();
trialLengthSoFar = Math.max(0,(parseInt(today,10) / one_day) - (trialStartDate * 0xF4240));
clearOutput();
if((trialLengthSoFar > trialLengthDays) || (todayInMsFixed < trialStartDate))
{
trialDaysLeft = 0;
}
else
{
trialDaysLeft = Math.ceil(trialLengthDays - trialLengthSoFar);
}
launchesLeft = Math.max(0,trialLengthLaunches - launchCount);
if(trialDaysLeft > 0)
{
writeLn(strTrialThanks);
writeLn(strTrialTxt.replace(RegExp("%E","g"),trialDaysLeft));
ExpressionTimelineGlobals.demoLeft = strTrialTxt.replace(RegExp("%E","g"),trialDaysLeft);
}
else
{
writeLn(strTrialThanks);
writeLn(strTrialTxt2.replace(RegExp("%E","g"),launchesLeft));
ExpressionTimelineGlobals.demoLeft = strTrialTxt2.replace(RegExp("%E","g"),launchesLeft);
}
if(((trialLengthSoFar > trialLengthDays) && (launchCount > trialLengthLaunches)) || (todayInMsFixed < trialStartDate))
{
trialExpired = true;
}
return  trialExpired;
}
}
function checkCode(doPrompt,myReg,privateNum)
{
	myLicense = "SUL";
	regOK = true;
	return  regOK?myLicense:"1";
var tempKey,nameEncode,goToUrl,myRegArray,name,key;
{
myLicense = "0";
if(doPrompt)
{
myReg = prompt(strTrialWelcomeMsg,"trial",strTrialWelcomeHeader);
}
regOK = false;
if(myReg)
{
if(myReg.toLowerCase() != "trial")
{
myRegArray = myReg.split("**");
if(myRegArray.length == 3)
{
myLicense = myRegArray[2].substring(myRegArray[2].length - 3,myRegArray[2].length);
name = (myRegArray[0] + myRegArray[1]) + myLicense;
tempKey = myRegArray[2].substring(0,myRegArray[2].length - 3);
nameEncode = (((((((((name.length * name.charCodeAt(0)) + name.charCodeAt(Math.floor((name.length - 1) * 0.100000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.200000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.300000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.400000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.500000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.700000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.800000))) + name.charCodeAt(Math.floor((name.length - 1) * 0.900000))) + name.charCodeAt(name.length - 1);
key = nameEncode * privateNum;
if(key == tempKey)
{
if(doPrompt)
{
app.settings.saveSetting(prefsSectionName,prefsName,myReg);
app.preferences.saveToDisk();
alert(strRegSuccess);
}
regOK = true;
}
else
{
if(doPrompt)
{
alert(strInvalidCode);
checkCode(doPrompt);
}
else
{
alert(strCorruptedCode);
doPrompt = true;
app.settings.saveSetting(prefsSectionName,prefsName,"bad");
app.preferences.saveToDisk();
checkCode(doPrompt);
}
}
}
else
{
alert(strInvalidCode);
doPrompt = true;
app.settings.saveSetting(prefsSectionName,prefsName,"bad");
app.preferences.saveToDisk();
checkCode(doPrompt);
}
}
else
{
if(checkTrial())
{
goToUrl = confirm(strExpiredAlert);
if(isSecurityPrefSet() && goToUrl)
openURL(strTrialUrl);
else
if(goToUrl)
alert(strErrScriptAccess);
}
else
{
myLicense = "trial";
regOK = true;
}
}
}
return  regOK?myLicense:"0";
}
}
function isSecurityPrefSet()
{
var securitySetting;
{
securitySetting = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY");
return  securitySetting == 1;
}
}
function retFile(url)
{
{
if($.os.indexOf("Windows") != -1)
{
system.callSystem((("cmd /c \"" + winBrowserCmd) + url) + "\"");
}
else
{
system.callSystem((macBrowserCmdStart + url) + macBrowserCmdEnd);
}
}
}
strScriptName = "ExpressionTimeline";
supportEmail = "support@aescripts.com";
trialLengthDays = 14;
trialLengthLaunches = 25;
strTrialUrl = "http://aescripts.com/expression-timeline/";
strExpiredAlert = localize({en:("Sorry, this trial version of the script has expired. \nYou can purchase a license at " + strTrialUrl) + "\n\nWould you like to go there now?",de:("Die Testversion des Skriptes ist leider abgelaufen.\n Du kannst unter " + strTrialUrl) + " eine Lizenz erwerben.\n\nM\xf6chtest Du jetzt dorthin gehen?"});
strRegSuccess = localize({en:("Registration Successful\nThank you for purchasing " + strScriptName) + " and supporting the AE scripting community!",de:("Registrierung erfolgreich\nDanke f\xfcr den Kauf von " + strScriptName) + " und die Unterst\xfctzung der AE Scripting Community!"});
strInvalidCode = localize({en:"Sorry, the registration code is not valid\n\nIf you require assistance please contact " + supportEmail,de:"Entschuldigung, der Registrierungscode ist nicht g\xfcltig.\n\nWenn Du Hilfe ben\xf6tigst, kontaktiere bitte " + supportEmail});
strCorruptedCode = localize({en:"Sorry, something must have happened to the registration code.  Please re-enter it at the prompt.\nIf you require assistance please contact " + supportEmail,de:"Entschuldigung, irgendetwas ist mit dem Registrierungscode passiert. Bitte gebe ihn erneut ein.\n\nWenn Du Hilfe ben\xf6tigst, kontaktiere bitte " + supportEmail});
strTrialThanks = localize({en:("Thanks for trying " + strScriptName) + "!",de:("Danke, dass Du " + strScriptName) + " ausprobierst!"});
strTrialTxt = localize({en:"%E days left in the trial",de:"%E Tage \xfcbrig f\xfcr die Testversion"});
strTrialTxt2 = localize({en:"%E launches left in the trial",de:"%E Programmstarts \xfcbrig f\xfcr die Testversion"});
strTrialWelcomeHeader = localize({en:"Welcome to " + strScriptName,de:"Willkommen bei " + strScriptName});
strErrScriptAccess = localize({en:"This script requires access to write files.\nGo to the \"General\" panel of the application preferences and make sure \"Allow Scripts to Write Files and Access Network\" is checked.",de:"Dieses Skript ben\xf6tigt die Erlaubnis Dateien zu schreiben.\n Gehe in Voreinstellungen von After Effects in die Rubrik \"Allgemein\" und aktiviere die Option \"Skripten k\xf6nnen Dateien schreiben und haben Netzwerkzugang\"."});
prefsSectionName = "aescripts";
prefsName = strScriptName + "_Registration";
winProgramFiles = Folder.commonFiles.parent.fsName;
winBrowserCmd = ($.os.indexOf("XP") != -1)?(("\"" + winProgramFiles) + "\\Internet Explorer\\iexplore.exe\" "):"start ";
macBrowserCmdStart = "open \"";
macBrowserCmdEnd = "\"";
if($.os.indexOf("Mac") != -1)
{
cmdKey = "\u2318";
}
else
{
cmdKey = "Ctrl";
}
strTrialWelcomeMsg = localize({en:((("Please enter the license code.\nIf pasting the code with " + cmdKey) + "+V doesn't work try ") + ((parseFloat(app.version) >= 10)?"Right-Click and Paste":"Edit->Paste")) + "\nIf you need to retrieve your license you can do so at http://license.aescripts.com  To run in trial mode type: trial\n",de:("Bitte gebe den Lizenzcode ein. Wenn das Einf\xfcgen mit " + cmdKey) + "+V nicht funktioniert, versuche Bearbeiten->Einf\xfcgen\n Deinen Lizenzcode erf\xe4hrst Du unter http://license.aescripts.com. Um die Testversion zu starten, gebe \"trial\" ein."});
privateNum = 0x295CA;
prefHeader = "Vector Shapes";
prefSection1 = "Vector Bezier Kernel";
prefSection2 = "Vector Bezier Multiplicity";
if(app.settings.haveSetting(prefsSectionName,prefsName))
{
myReg = app.settings.getSetting(prefsSectionName,prefsName);
if(myReg == "bad")
{
doPrompt = true;
}
else
{
doPrompt = false;
}
theLicense = checkCode(doPrompt,myReg,privateNum);
}
else
{
doPrompt = true;
theLicense = checkCode(doPrompt,myReg,privateNum);
}
return  theLicense;
}
}
ExpressionTimelineGlobals = new Object();
ExpressionTimelineGlobals.scriptName = "ExpressionTimeline";
ExpressionTimelineGlobals.scriptVersionNumber = "1.2";
ExpressionTimelineGlobals.scriptVersion = "Version " + ExpressionTimelineGlobals.scriptVersionNumber;
ExpressionTimelineGlobals.scriptURLName = "3286";
ExpressionTimelineGlobals.path = File($.fileName).path + "/";
ExpressionTimelineGlobals.myPrefFolder = Folder.userData.fsName + "/Aescripts/ExpressionTimeline/";
if(! Folder(Folder.userData.fsName + "/Aescripts").exists)
{
aeFolder = new Folder(Folder.userData.fsName + "/Aescripts");
if(allowedToWriteFiles(true))
{
aeFolder.create();
if(aeFolder.Error)
{
myError(((loc({en:"Could not create the following folder:",de:"Konnte den folgenden Ordner nicht erzeugen:"}) + aeFolder.absoluteURI) + "\n") + aeFolder.error);
}
}
}
if(! Folder(Folder.userData.fsName + "/Aescripts/ExpressionTimeline").exists)
{
timelineFolder = new Folder(Folder.userData.fsName + "/Aescripts/ExpressionTimeline");
if(allowedToWriteFiles(true))
{
timelineFolder.create();
if(timelineFolder.Error)
{
myError(((loc({en:"Could not create the following folder:",de:"Konnte den folgenden Ordner nicht erzeugen:"}) + timelineFolder.absoluteURI) + "\n") + timelineFolder.error);
}
}
}
ExpressionTimelineGlobals.logoString = "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";
ExpressionTimelineGlobals.logoFile = getIcon(File(ExpressionTimelineGlobals.myPrefFolder + "expressiontimeline_logo.png"),ExpressionTimelineGlobals.logoString);
ExpressionTimelineGlobals.settingsSection = ExpressionTimelineGlobals.scriptName + " - Settings";
ExpressionTimelineGlobals.language = app.settings.haveSetting(ExpressionTimelineGlobals.settingsSection,"language")?app.settings.getSetting(ExpressionTimelineGlobals.settingsSection,"language"):"auto";
ExpressionTimelineGlobals.onlineUpdate = app.settings.haveSetting(ExpressionTimelineGlobals.settingsSection,"onlineUpdate")?(app.settings.getSetting(ExpressionTimelineGlobals.settingsSection,"onlineUpdate") == "true"):true;
if(ExpressionTimelineGlobals.onlineUpdate)
{
checkUpdates(true);
}
ExpressionTimelineGlobals.isMacOS = $.os.indexOf("Mac") != -1;
ExpressionTimelineGlobals.helpTextEn = ((((((((((((((((((((ExpressionTimelineGlobals.scriptName + " ") + ExpressionTimelineGlobals.scriptVersion) + " by mamoworld.com (c) 2011\n") + "\n") + "Videotutorial for the ExpressionTimeline can be found at http://www.mamoworld.com\n") + "\n") + "With the ExpressionTimeline you can apply one or more expressions to a property such that each of them is only active for a certain range in time. You can for example create a wiggle expression that wiggles the layer not all the time but only let\u2019s say from frame 100 to 200. During the times where the expression is not active, you can keyframe the property as usual. You can also apply several expressions for different points in time. For example, you could have your wiggle expression from frame 100 to 200 and a completely different expression from frame 300 to 350. You can also smoothly transition between the expressions (or between expressions and parts where no expression is active). By adding a fade at the beginning and the end of the wiggle expression, the wiggle does not start and stop abruptly at frames 100 and 200, respectively but smoothly starts and stops the wiggling, instead. The ExpressionTimeline works with arbitrary After Effects expressions and can combine arbitrarily many of them.\n") + "\n") + "CREATING EXPRESSIONS\n") + "\n") + "The user interface of ExpressionTimeline has the form of a timeline. The different expressions are arranged on it from left to right according to the times at which they are active. In-between the different expressions frame numbers are written that indicate at which times the respective expressions are active. At the beginning, the timeline consists only of a single entry, namely keyframes, from frame 0 to infinity (i.e. the end of the composition). With a click on \"Add Expression\" you can turn the entry into an expression (that can then simply be pasted into the corresponding text box). This expression is now also active from frame 0 until infinity. If the expression should start e.g. at frame 50, the text \"frame 0\" left of the expression can simply be replaced by \"frame 50\". This automatically adds a new entry to the timeline for the range between frames 0 and 50. In this range, again either keyframes or an expression can be active. You can make the transition between the two timeline entries (at frame 50) smooth by clicking on \"Add Fade\". If you set the duration of the fade to 20, for example, the expression does not start abruptly at frame 50, but gets continuously stronger and stronger in between frames 40 and 60. \n") + "\n") + "APPLYING EXPRESSIONS\n") + " \n") + "When you have created some expressions in the timeline, they are not immediately active in the property. For this, you need to select the property and click the \"Apply\" button in the timeline interface. You can also select more than one property to apply the expressions to all of them simultaneously. If you want to create new expressions for other properties, you can now safely click the \"Clear All\" button. By this, only the timeline interface is emptied, but in all properties that you applied the timeline expressions to, they are maintained. \n") + "\n") + "MODIFYING EXPRESSIONS LATER\n") + "If you created some expressions with the ExpressionTimeline, you can always go back and modify them later, also if you cleared the expressions via the \"Clear All\" button from the user interface. For this you only need to select the property whose expressions you want to modify and click on \"Load\". By that, the expressions for this property occur again in the timeline and can easily be modified and again be applied to this or other properties.\n") + "\n") + "GENERAL REMARKS\n") + "Expressions that you create with the expression timeline behave exactly as usual expressions. In particular you can deactivate, delete, copy, etc. them as usual. They also work in machines where ExpressionTimeline is not installed (except that you cannot modify them, of course). \n";
ExpressionTimelineGlobals.helpTextDe = (((((((((((((((((((((((ExpressionTimelineGlobals.scriptName + " ") + ExpressionTimelineGlobals.scriptVersion) + " von mamoworld.com (c) 2011\n") + "\n") + "Videotutorials zur ExpressionTimeline findest Du unter http://www.mamoworld.com\n") + "\n") + "Mit der ExpressionTimeline kannst Du eine oder mehrere Expressions so auf eine Eigenschaft anwenden, dass sie nur f\xfcr einen begrenzten Zeitraum aktiv ist. Eine Wiggle-Expression l\xe4sst die Eigenschaft also z.B. nicht die gesamte Zeit wackeln, sondern etwa nur von Frame 100 bis 200. In den Zeitr\xe4umen, wo die Expression nicht aktiv ist, kannst du den Wert ganz normal \xfcber die Keyframes animieren. Du kannst auch mehrere Expressions zu unterschiedlichen Zeitpunkten aktivieren, also beispielsweise einen Wiggle von Frame 100 bis 200 und eine v\xf6llig andere Expression von Frame 300 bis 350. Kontinuierliche \xdcberg\xe4nge bzw. \xdcberblendungen zwischen den Expressions sind ebenfalls ganz einfach m\xf6glich. Durch eine \xdcberblendung am Anfang und am Ende einer Wiggle-Expression f\xe4ngt das Wackeln z.B. langsam an und h\xf6rt langsam wieder auf anstatt abrupt zu starten und zu enden. Die ExpressionTimeline funktioniert mit allen After Effects Expressions und kann beliebig viele davon kombinieren.\n") + "\n") + "\n") + "EXPRESSSIONS ERZEUGEN\n") + "\n") + "Die Benutzeroberfl\xe4che der ExpressionTimeline hat die Form einer Zeitleiste. Die verschiedenen Expressions werden von links nach rechts im Verlauf der Zeit angeordnet. Zwischen den einzelnen Expressions stehen die Frame-Nummern innerhalb derer die jeweiligen Expressions aktiv sind. Zu Beginn besteht die Zeitleiste aus nur einem Eintrag, n\xe4mlich Keyframes von Frame 0 bis \u201einfinity\u201c (unendlich, also dem Ende der Komposition). Durch einen Klick auf \u201eNeue Expression\u201c l\xe4sst sich dieser Bereich mit einer Expression versehen, die Du einfach in die entsprechende Textbox einf\xfcgen kannst. Diese Expression ist jetzt auch von Frame 0 bis zum Ende der Komposition aktiv. Wenn die Expression z.B. erst an Frame 50 starten soll, ersetze die Angabe \u201eFrame 0\u201c vor der Expression durch \u201eFrame 50\u201c. Automatisch erscheint ein neuer Eintrag in der ExpressionTimeline f\xfcr den Bereich 0 bis 50. Hier k\xf6nnen nun wieder die Keyframes oder eine neue Expression aktiv sein. Am \xdcbergang an Frame 50 kann man durch einen Klick auf \u201e\xdcberblendung\u201c einen weichen \xdcbergang einstellen, so dass die Expression nicht abrupt startet sondern weicher.\n") + "\n") + "EXPRESSION ANWENDEN\n") + "\n") + "Wenn Du eine Expression in der ExpressionTimeline erzeugt hast, ist sie noch nicht direkt in Deiner Eigenschaft aktiv. Dazu musst Du die Eigenschaft zun\xe4chst ausw\xe4hlen und dann in der ExpressionTimeline auf \u201eAnwenden\u201c klicken. Du kannst auch mehrere Eigenschaften ausw\xe4hlen, um auf alle gleichzeitig die Expression anzuwenden. Sobald Du auf Anwenden geklickt hast, werden die Expressions aus der ExpressionTimeline auf die ausgew\xe4hlten Eigenschaften angewendet. Wenn du mit der ExpressionTimeline neue Expressions f\xfcr eine andere Eigenschaft zusammenstellen willst, kannst Du \xfcber \u201eAlles L\xf6schen\u201c die ExpressionTimeline leeren und mit der neuen Expression beginnen. Dadurch wird nur die Benutzeroberfl\xe4che gel\xf6scht; in den Eigenschaften, auf die Du die Expression angewendet hast, bleibt die Expression aktiv.\n") + "\n") + "EXPRESSION NACHTR\xc4GLICH VER\xc4NDERN\n") + "\n") + "Mit ExpressionTimeline erstellte Expressions kannst Du auch nachtr\xe4glich modifizieren, auch wenn du sie \xfcber \u201eAlles L\xf6schen\u201c aus der Benutzeroberfl\xe4che gel\xf6scht hast. Dazu brauchst Du nur die Eigenschaft, deren Expression du ver\xe4ndern m\xf6chtest, ausw\xe4hlen und in der ExpressionTimeline-Oberfl\xe4che auf \u201eLaden\u201c klicken. Danach kannst  du die Expressions beliebig ver\xe4ndern und wieder auf die Eigenschaft anwenden.\n") + "\n") + "ALLGEMEINE HINWEISE\n") + "\n") + "Mit der ExpressionTimeline erzeugte Expressions verhalten sich ganz genau wie normale Expressions. Sie lassen sich also genau so deaktivieren, l\xf6schen, kopieren etc. Mit der ExpressionTimeline erzeugte Expressions funktionieren auch auf anderen Rechnern, auf denen die ExpressionTimeline nicht installiert ist. Nur nachtr\xe4glich ver\xe4ndern kann man sie dort nat\xfcrlich nicht.";
ExpressionTimelineGlobals.helpText = loc({en:ExpressionTimelineGlobals.helpTextEn,de:ExpressionTimelineGlobals.helpTextDe});
ExpressionTimelineGlobals.defaultFadeDuration = 10;
ExpressionTimelineGlobals.eulaEn = "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.";
ExpressionTimelineGlobals.eulaDe = "DIE SOFTWARE WIRD OHNE JEDE AUSDR\xdcCKLICHE ODER IMPLIZIERTE GARANTIE BEREITGESTELLT, EINSCHLIESSLICH DER GARANTIE ZUR BENUTZUNG F\xdcR DEN VORGESEHENEN ODER EINEM BESTIMMTEN ZWECK SOWIE JEGLICHER RECHTSVERLETZUNG, JEDOCH NICHT DARAUF BESCHR\xc4NKT. IN KEINEM FALL SIND DIE AUTOREN ODER COPYRIGHTINHABER F\xdcR JEGLICHEN SCHADEN ODER SONSTIGE ANSPR\xdcCHE HAFTBAR ZU MACHEN, OB INFOLGE DER ERF\xdcLLUNG EINES VERTRAGES, EINES DELIKTES ODER ANDERS IM ZUSAMMENHANG MIT DER SOFTWARE ODER SONSTIGER VERWENDUNG DER SOFTWARE ENTSTANDEN.";
ExpressionTimelineGlobals.eula = loc({en:ExpressionTimelineGlobals.eulaEn,de:ExpressionTimelineGlobals.eulaDe});
ExpressionTimelineGlobals.timeSlices = new Array();
ExpressionTimelineGlobals.timeSlices.push(generateTimeSliceKeyframes(0,"infinity"));
ScrollableLayout.prototype.initSelf = SL_initSelf;
ScrollableLayout.prototype.layout = SL_layout;
ScrollableLayout.prototype.resize = SL_layout;
serial_Check = expressiontimeline_trial_serialization();

userinterface = buildUI(this);
if((userinterface != null) && (userinterface instanceof Window))
userinterface.show();
}
